********************************************************************************
*** 						RESULTS											 ***
********************************************************************************
* Housekeeping 
clear all 
set more off

global dataPath "F:\Prosjekt\CostBenefitProjectCCB\Krisesannsynlighetsmodell\Data_merge"
global outputTables "F:\Prosjekt\CostBenefitProjectCCB\Krisesannsynlighetsmodell\Staff_memo\Tables"
global outputFigures "F:\Prosjekt\CostBenefitProjectCCB\Krisesannsynlighetsmodell\Staff_memo\Figures"
cd "F:\Prosjekt\CostBenefitProjectCCB\Krisesannsynlighetsmodell\Staff_memo\Codes\Calibration of thresholds"

* Load data
use $dataPath\master_data

* Transforming data
do $dataPath\Transforming_variables

* The real interest rate
gen real_rate = rshort - dlogcpi 
sum real_rate
label variable real_rate "Real short-term interest rate"

gen real_rate_long = rlong - dlogcpi 
sum real_rate_long
label variable real_rate_long "Real long-term interest rate"

/* The exuberance measures do not make sense in certain periods and countries */
*twoway (line pcredit_gdp quarter) (line ind_credit_gdp_exu quarter, yaxis(2)) if country == "Belgium"
*twoway (line hp_disp_inc quarter) (line ind_hp_inc_exu quarter, yaxis(2)) if country == "Belgium"

*Korea
replace ind_hp_exu = 0 if country == "Korea" & year > 1990
replace ind_hp_inc_exu = 0 if country == "Korea" & year > 1990

*Japan
replace ind_hp_exu = 0 if country == "Japan" & year > 1995
replace ind_hp_inc_exu = 0 if country == "Japan" & year > 1995
replace ind_credit_gdp_exu = 0 if country == "Japan" & year > 2000

*Germany
replace ind_hp_exu = 0 if country == "Germany"
replace ind_hp_inc_exu = 0 if country == "Germany"

*Other 
replace ind_credit_gdp_exu = 0 if country == "Italy" & year < 1990

	  
****************************
*** (1) Baseline Results ***
****************************

logit crisis4_12 dlogpcredit pcredit_gap_nb hp_inc_gap i.country_id if gdp_gap != ., robust cluster(period)
predict p1, p

logit crisis4_12 dlogpcredit pcredit_gap_nb hp_inc_gap gdp_gap i.country_id, robust cluster(period)
predict p2, p

logit crisis4_12 dlogpcredit pcredit_gap_nb hp_inc_gap gdp_gap i.country_id if wholesale_gap_nb != . & equity_assets != ., robust cluster(period)
predict p3, p

logit crisis4_12 dlogpcredit pcredit_gap_nb hp_inc_gap wholesale_gap_nb equity_assets i.country_id if gdp_gap != ., robust cluster(period)
predict p4, p

logit crisis4_12 dlogpcredit pcredit_gap_nb hp_inc_gap_nb wholesale_gap_nb equity_assets gdp_gap i.country_id, robust cluster(period)
predict p5, p

										  
***************************
*** (2)  Which Credit?  ***
***************************
logit crisis4_12 dlogpcredit hcredit_gap_nb nfecredit_gap_nb hp_inc_gap i.country_id if gdp_gap !=., robust cluster(period)
predict p6, p

logit crisis4_12 dlogpcredit hcredit_gap_nb nfecredit_gap_nb hp_inc_gap gdp_gap i.country_id, robust cluster(period)
predict p7, p

logit crisis4_12 dlogpcredit hcredit_gap_nb nfecredit_gap_nb hp_inc_gap gdp_gap i.country_id if wholesale_gap_nb != . & equity_assets != ., robust cluster(period)
predict p8, p

logit crisis4_12 dlogpcredit hcredit_gap_nb nfecredit_gap_nb hp_inc_gap wholesale_gap_nb equity_assets i.country_id if gdp_gap != . , robust cluster(period)
predict p9, p

logit crisis4_12 dlogpcredit hcredit_gap_nb nfecredit_gap_nb hp_inc_gap wholesale_gap_nb equity_assets gdp_gap i.country_id, robust cluster(period)
predict p10, p


*******************************
*** (3) Global Developments ***
*******************************
regress global_gap_nb pcredit_gap_nb
predict interak1, res
corr interak1 pcredit_gap_nb

regress global_hp_gap hp_inc_gap_nb
predict interak2, res
corr interak2 hp_inc_gap_nb

replace global_gap_nb = interak1
replace global_hp_gap = interak2
corr global_hp_gap hp_inc_gap_nb
corr global_gap_nb pcredit_gap_nb

set more off
logit crisis4_12 dlogpcredit pcredit_gap_nb hp_inc_gap global_gap_nb global_hp_gap i.country_id if gdp_gap != ., robust cluster(period)
predict p11, p


logit crisis4_12 dlogpcredit pcredit_gap_nb hp_inc_gap global_gap_nb global_hp_gap gdp_gap i.country_id, robust cluster(period)
predict p12, p


logit crisis4_12 dlogpcredit pcredit_gap_nb hp_inc_gap global_gap_nb global_hp_gap gdp_gap i.country_id if wholesale_gap_nb != . & equity_assets !=. & gdp_gap !=., robust cluster(period)
predict p13, p


logit crisis4_12 dlogpcredit pcredit_gap_nb hp_inc_gap wholesale_gap_nb equity_assets global_gap_nb global_hp_gap i.country_id if gdp_gap != ., robust cluster(period)
predict p14, p

logit crisis4_12 dlogpcredit pcredit_gap_nb hp_inc_gap wholesale_gap_nb equity_assets global_gap_nb global_hp_gap gdp_gap i.country_id, robust cluster(period)
predict p15, p

*********************************
*** (4) Exuberance Indicators ***
********************************* 

set more off
logit crisis4_12 dlogpcredit pcredit_gap_nb hp_inc_gap i.ind_hp_inc_exu i.ind_credit_gdp_exu i.country_id if gdp_gap !=., robust cluster(period)
predict p16, p

logit crisis4_12 dlogpcredit pcredit_gap_nb hp_inc_gap i.ind_hp_inc_exu i.ind_credit_gdp_exu gdp_gap i.country_id , robust cluster(period)
predict p17, p


logit crisis4_12 dlogpcredit pcredit_gap_nb hp_inc_gap i.ind_hp_inc_exu i.ind_credit_gdp_exu gdp_gap i.country_id if wholesale_gap_nb != . & equity_assets !=. & gdp_gap !=., robust cluster(period)
predict p18, p


logit crisis4_12 dlogpcredit pcredit_gap_nb hp_inc_gap i.ind_hp_inc_exu i.ind_credit_gdp_exu wholesale_gap_nb equity_assets  i.country_id if gdp_gap !=., robust cluster(period)
predict p19, p


logit crisis4_12 dlogpcredit pcredit_gap_nb hp_inc_gap i.ind_hp_inc_exu i.ind_credit_gdp_exu wholesale_gap_nb equity_assets gdp_gap i.country_id, robust cluster(period)
predict p20, p

											  										   												
**************************************************************************
***  The models using alternative transformations of the key variables ***
**************************************************************************                
* Orthogonalizing thje global variables
drop interak1 interak2
regress dlogglobal_credit dlogreal_pcredit
predict interak1, res
corr interak1 dlogreal_pcredit

regress dlogglobal_hp dlogreal_hp
predict interak2, res
corr interak2 hp_inc_gap_nb



set more off
logit crisis4_12 dlogreal_pcredit dlogreal_hp dwholesale_assets equity_assets gdp_gap i.country_id, robust cluster(period)
predict pa1, p

logit crisis4_12 dlogreal_hcredit dlogreal_nfecredit dlogreal_hp dwholesale_assets equity_assets gdp_gap i.country_id, robust cluster(period)
predict pa2, p

logit crisis4_12 dlogreal_pcredit dlogreal_hp dwholesale_assets equity_assets dlogglobal_credit dlogglobal_hp gdp_gap i.country_id, robust cluster(period)
predict pa3, p

logit crisis4_12 dlogreal_pcredit dloghp dwholesale_assets equity_assets i.ind_hp_inc_exu i.ind_credit_gdp_exu gdp_gap i.country_id, robust cluster(period)
predict pa4, p


*** Using changes in the ratios ***
gen dglobal_credit_gdp = (global_credit_gdp - L4.global_credit_gdp)/100
gen dglobal_hp_inc = (global_hp_inc - l4.global_hp_inc)/100


set more off
logit crisis4_12 dpcredit_gdp dhp_disp_inc dwholesale_assets  equity_assets gdp_gap i.country_id, robust cluster(period)
predict pa5, p


logit crisis4_12 dhcredit_gdp dnfecredit_gdp dhp_disp_inc dwholesale_assets equity_assets gdp_gap i.country_id, robust cluster(period)
predict pa6, p


logit crisis4_12 dpcredit_gdp dhp_disp_inc dwholesale_assets  equity_assets dglobal_credit_gdp  dglobal_hp_inc gdp_gap i.country_id, robust cluster(period)
predict pa7, p

logit crisis4_12 dpcredit_gdp dhp_disp_inc dwholesale_assets equity_assets i.ind_hp_inc_exu i.ind_credit_gdp_exu gdp_gap i.country_id, robust cluster(period)
predict pa8, p



********************************************************************************
preserve 
cd "F:\Prosjekt\CostBenefitProjectCCB\Krisesannsynlighetsmodell\Staff_memo\Codes\Calibration of thresholds"
* frequency of pre-crisis states  
egen p_1 = mean(crisis4_12)
sum p_1 
gen p_2 =  1 - p_1

foreach var in p1 p2 p6 p7 p11 p12 {
	gen `var'_cut = .
	}

set more off
foreach var in p1 p2 p6 p7 p11 p12 {	
	forvalues i = 1(1)16 {
		egen `var'_cut`i' = cut(`var') if country_id == `i', group(100)
		replace `var'_cut = `var'_cut`i' if country_id == `i'
		drop `var'_cut`i'
	}
}

foreach var of varlist p1_cut p2_cut p6_cut p7_cut p11_cut p12_cut {
	forvalues j=0.85(0.05)1 {

** VARIABLE TO BE EVALUATED
gen EV_VAR = `var'
local var_name : variable label `var'
gen varname = "`var'"
** parameters: cons1 = mu, cons2 = 1-mu, cons3 = min(mu,1-mu), 
gen cons1 = `j'
gen cons2 = 1 - cons1 
egen cons3 = rowmin(cons1 cons2)
** period that you want to detect
gen PRECRISIS = crisis4_12

* probweighted
gen p1mu1 = p_1 * `j'
gen p2mu2 = p_2 * (1-`j')
egen wcons3 =  rowmin(p1mu1 p2mu2)

******

set more off

* generate signals based on percentile thresholds (50th to 99th percentile)
* generate counter variables for A, B, C, D fields
forvalues i=1(1)99{
gen sig`i' = .
replace sig`i' = 0 if EV_VAR < `i' & EV_VAR != . 
replace sig`i' = 1 if EV_VAR >= `i' & EV_VAR != . 
replace sig`i' = . if start_crisisf3 == 1 |start_crisisf2 == 1 | start_crisisf1 == 1 ///
					  | start_crisis == 1 | start_crisisl1 == 1 | start_crisisl2 == 1 ///
					  | start_crisisl3 == 1 | start_crisisl4 == 1 | start_crisisl5 == 1 ///
					  | start_crisisl6 == 1 | start_crisisl7 == 1 
replace sig`i' = . if bankingcrisis == 1 
gen counter_yesyes`i' = 1 if sig`i' == 1 & PRECRISIS == 1
gen counter_yesno`i' = 1 if sig`i' == 1 & PRECRISIS == 0
gen counter_noyes`i' = 1 if sig`i' == 0 & PRECRISIS == 1
gen counter_nono`i' = 1 if sig`i' == 0 & PRECRISIS == 0
}

* one percentile for all countries (means that cutoff values vary over countries while percentile remains constant)
forvalues i=1(1)99{
egen global_A`i' = total(counter_yesyes`i')
egen global_B`i' = total(counter_yesno`i')
egen global_C`i' = total(counter_noyes`i')
egen global_D`i' = total(counter_nono`i')
gen global_A_AC`i' = global_A`i' / ( global_A`i' + global_C`i' )
gen global_A_AB`i' = global_A`i' / ( global_A`i' + global_B`i' )
gen global_C_AC`i' = global_C`i' / ( global_A`i' + global_C`i' )
gen global_B_BD`i' = global_B`i' / ( global_B`i' + global_D`i' )
gen global_AC_ABCD`i' = ( global_A`i' + global_C`i' ) / ( global_A`i' + global_B`i' + global_C`i' + global_D`i' )
gen global_adj_noise_signal`i' = global_B_BD`i' / global_A_AC`i'
gen global_use`i' = cons3 - ( cons1 * global_C_AC`i' + cons2 * global_B_BD`i' )
gen weight_global_use`i' = wcons3 - ( p1mu1 * global_C_AC`i' + p2mu2 * global_B_BD`i' )
gen rel_weight_global_use`i' = ( wcons3 - ( p1mu1 * global_C_AC`i' + p2mu2 * global_B_BD`i' ) ) / wcons3
}

* identify maximum relative usefulness across percentiles
egen maxweightglobaluse = rowmax(weight_global_use*)
egen maxrelweightglobaluse = rowmax(rel_weight_global_use*)
* define the optimal thresholds and corresponding values as the ones where usefulness is at its maximum
gen optweight_thres_global = . 
gen ow_adj_noise_signal_global = .
gen optweight_perc_pred_global = . 
gen optweight_cond_prob_global = . 
gen optweight_prob_diff_global = .
gen optweight_TP = .
gen optweight_FP = .
gen optweight_TN = .
gen optweight_FN = . 
gen optweight_T1 = .
gen optweight_T2 = .
forvalues i=1(1)99{
replace optweight_thres_global = `i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace ow_adj_noise_signal_global = global_adj_noise_signal`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace optweight_perc_pred_global = global_A_AC`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace optweight_cond_prob_global = global_A_AB`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace optweight_prob_diff_global = global_A_AB`i' - global_AC_ABCD`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace optweight_TP = global_A`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace optweight_FP = global_B`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace optweight_TN = global_D`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace optweight_FN = global_C`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace optweight_T1 = global_C_AC`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace optweight_T2 = global_B_BD`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
}

* drop variables
forvalues i=1(1)99{
drop sig`i' counter_yesyes`i' counter_yesno`i' counter_noyes`i' counter_nono`i' ///
			global_A`i' global_B`i' global_C`i' global_D`i' global_A_AC`i'      ///
			global_A_AB`i' global_C_AC`i' global_B_BD`i' global_AC_ABCD`i'      ///
			global_adj_noise_signal`i' global_use`i' weight_global_use`i'       ///
			rel_weight_global_use`i'
			}

order varname cons1 optweight_thres_global ///
			  optweight_TP optweight_FP optweight_TN optweight_FN ///
			  optweight_T1 optweight_T2 ///
			  maxweightglobaluse maxrelweightglobaluse ///
			  ow_adj_noise_signal_global optweight_perc_pred_global ///
			  optweight_cond_prob_global optweight_prob_diff_global ///
			  

outsheet         varname cons1 optweight_thres_global optweight_TP optweight_FP optweight_TN optweight_FN ///
				 optweight_T1 optweight_T2 maxweightglobaluse maxrelweightglobaluse ow_adj_noise_signal_global ///
				 optweight_perc_pred_global optweight_cond_prob_global optweight_prob_diff_global ///
				 using "help.csv" in 1, comma nonames replace

appendfile help.csv calibration.csv 

erase help.csv

drop PRECRISIS EV_VAR varname cons1 cons2 cons3 p1mu1 p2mu2 wcons3 optweight_thres_global ///
	 optweight_TP optweight_FP optweight_TN optweight_FN optweight_T1 optweight_T2 		  ///
	 maxweightglobaluse maxrelweightglobaluse optweight_thres_global ow_adj_noise_signal_global ///
	 optweight_perc_pred_global optweight_cond_prob_global optweight_prob_diff_global  
 
	}
	}

restore 

********************************************************************************

preserve 

drop if country_id == 3
drop country_id 
egen country_id = group(country)
* frequency of pre-crisis states  
egen p_1 = mean(crisis4_12)
sum p_1 
gen p_2 =  1 - p_1

foreach var in p16 p17 {
	gen `var'_cut = .
	}

set more off
foreach var in p16 p17  {	
	forvalues i = 1(1)15 {
		egen `var'_cut`i' = cut(`var') if country_id == `i', group(100)
		replace `var'_cut = `var'_cut`i' if country_id == `i'
		drop `var'_cut`i'
	}
}

foreach var of varlist p16_cut p17_cut {
		forvalues j=0.85(0.05)1 {

** VARIABLE TO BE EVALUATED
gen EV_VAR = `var'
local var_name : variable label `var'
gen varname = "`var'"
** parameters: cons1 = mu, cons2 = 1-mu, cons3 = min(mu,1-mu), 
gen cons1 = `j'
gen cons2 = 1 - cons1 
egen cons3 = rowmin(cons1 cons2)
** period that you want to detect
gen PRECRISIS = crisis4_12

* probweighted
gen p1mu1 = p_1 * `j'
gen p2mu2 = p_2 * (1-`j')
egen wcons3 =  rowmin(p1mu1 p2mu2)

******

set more off

* generate signals based on percentile thresholds (50th to 99th percentile)
* generate counter variables for A, B, C, D fields
forvalues i=1(1)99{
gen sig`i' = .
replace sig`i' = 0 if EV_VAR < `i' & EV_VAR != . 
replace sig`i' = 1 if EV_VAR >= `i' & EV_VAR != . 
replace sig`i' = . if start_crisisf3 == 1 |start_crisisf2 == 1 | start_crisisf1 == 1 ///
					  | start_crisis == 1 | start_crisisl1 == 1 | start_crisisl2 == 1 ///
					  | start_crisisl3 == 1 | start_crisisl4 == 1 | start_crisisl5 == 1 ///
					  | start_crisisl6 == 1 | start_crisisl7 == 1 
replace sig`i' = . if bankingcrisis == 1 
gen counter_yesyes`i' = 1 if sig`i' == 1 & PRECRISIS == 1
gen counter_yesno`i' = 1 if sig`i' == 1 & PRECRISIS == 0
gen counter_noyes`i' = 1 if sig`i' == 0 & PRECRISIS == 1
gen counter_nono`i' = 1 if sig`i' == 0 & PRECRISIS == 0
}

* one percentile for all countries (means that cutoff values vary over countries while percentile remains constant)
forvalues i=1(1)99{
egen global_A`i' = total(counter_yesyes`i')
egen global_B`i' = total(counter_yesno`i')
egen global_C`i' = total(counter_noyes`i')
egen global_D`i' = total(counter_nono`i')
gen global_A_AC`i' = global_A`i' / ( global_A`i' + global_C`i' )
gen global_A_AB`i' = global_A`i' / ( global_A`i' + global_B`i' )
gen global_C_AC`i' = global_C`i' / ( global_A`i' + global_C`i' )
gen global_B_BD`i' = global_B`i' / ( global_B`i' + global_D`i' )
gen global_AC_ABCD`i' = ( global_A`i' + global_C`i' ) / ( global_A`i' + global_B`i' + global_C`i' + global_D`i' )
gen global_adj_noise_signal`i' = global_B_BD`i' / global_A_AC`i'
gen global_use`i' = cons3 - ( cons1 * global_C_AC`i' + cons2 * global_B_BD`i' )
gen weight_global_use`i' = wcons3 - ( p1mu1 * global_C_AC`i' + p2mu2 * global_B_BD`i' )
gen rel_weight_global_use`i' = ( wcons3 - ( p1mu1 * global_C_AC`i' + p2mu2 * global_B_BD`i' ) ) / wcons3
}

* identify maximum relative usefulness across percentiles
egen maxweightglobaluse = rowmax(weight_global_use*)
egen maxrelweightglobaluse = rowmax(rel_weight_global_use*)
* define the optimal thresholds and corresponding values as the ones where usefulness is at its maximum
gen optweight_thres_global = . 
gen ow_adj_noise_signal_global = .
gen optweight_perc_pred_global = . 
gen optweight_cond_prob_global = . 
gen optweight_prob_diff_global = .
gen optweight_TP = .
gen optweight_FP = .
gen optweight_TN = .
gen optweight_FN = . 
gen optweight_T1 = .
gen optweight_T2 = .
forvalues i=1(1)99{
replace optweight_thres_global = `i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace ow_adj_noise_signal_global = global_adj_noise_signal`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace optweight_perc_pred_global = global_A_AC`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace optweight_cond_prob_global = global_A_AB`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace optweight_prob_diff_global = global_A_AB`i' - global_AC_ABCD`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace optweight_TP = global_A`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace optweight_FP = global_B`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace optweight_TN = global_D`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace optweight_FN = global_C`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace optweight_T1 = global_C_AC`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace optweight_T2 = global_B_BD`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
}

* drop variables
forvalues i=1(1)99{
drop sig`i' counter_yesyes`i' counter_yesno`i' counter_noyes`i' counter_nono`i' ///
			global_A`i' global_B`i' global_C`i' global_D`i' global_A_AC`i'      ///
			global_A_AB`i' global_C_AC`i' global_B_BD`i' global_AC_ABCD`i'      ///
			global_adj_noise_signal`i' global_use`i' weight_global_use`i'       ///
			rel_weight_global_use`i'
			}

order varname cons1 optweight_thres_global ///
			  optweight_TP optweight_FP optweight_TN optweight_FN ///
			  optweight_T1 optweight_T2 ///
			  maxweightglobaluse maxrelweightglobaluse ///
			  ow_adj_noise_signal_global optweight_perc_pred_global ///
			  optweight_cond_prob_global optweight_prob_diff_global ///
			  

outsheet         varname cons1 optweight_thres_global optweight_TP optweight_FP optweight_TN optweight_FN ///
				 optweight_T1 optweight_T2 maxweightglobaluse maxrelweightglobaluse ow_adj_noise_signal_global ///
				 optweight_perc_pred_global optweight_cond_prob_global optweight_prob_diff_global ///
				 using "help.csv" in 1, comma nonames replace

appendfile help.csv calibration.csv 

erase help.csv

drop PRECRISIS EV_VAR varname cons1 cons2 cons3 p1mu1 p2mu2 wcons3 optweight_thres_global ///
	 optweight_TP optweight_FP optweight_TN optweight_FN optweight_T1 optweight_T2 		  ///
	 maxweightglobaluse maxrelweightglobaluse optweight_thres_global ow_adj_noise_signal_global ///
	 optweight_perc_pred_global optweight_cond_prob_global optweight_prob_diff_global  
 
	}
	}

restore

********************************************************************************

preserve 

drop if country == "UK" | country == "Australia" | country == "Canada"
drop country_id 
egen country_id = group(country)
* frequency of pre-crisis states  
egen p_1 = mean(crisis4_12)
sum p_1 
gen p_2 =  1 - p_1

foreach var in p3 p4 p5 p8 p9 p10 {
	gen `var'_cut = .
	}

set more off
foreach var in p3 p4 p5 p8 p9 p10  {	
	forvalues i = 1(1)13 {
		egen `var'_cut`i' = cut(`var') if country_id == `i', group(100)
		replace `var'_cut = `var'_cut`i' if country_id == `i'
		drop `var'_cut`i'
	}
}

foreach var of varlist p3_cut p4_cut p5_cut p8_cut p9_cut p10_cut {
		forvalues j=0.85(0.05)1 {

** VARIABLE TO BE EVALUATED
gen EV_VAR = `var'
local var_name : variable label `var'
gen varname = "`var'"
** parameters: cons1 = mu, cons2 = 1-mu, cons3 = min(mu,1-mu), 
gen cons1 = `j'
gen cons2 = 1 - cons1 
egen cons3 = rowmin(cons1 cons2)
** period that you want to detect
gen PRECRISIS = crisis4_12

* probweighted
gen p1mu1 = p_1 * `j'
gen p2mu2 = p_2 * (1-`j')
egen wcons3 =  rowmin(p1mu1 p2mu2)

******

set more off

* generate signals based on percentile thresholds (50th to 99th percentile)
* generate counter variables for A, B, C, D fields
forvalues i=1(1)99{
gen sig`i' = .
replace sig`i' = 0 if EV_VAR < `i' & EV_VAR != . 
replace sig`i' = 1 if EV_VAR >= `i' & EV_VAR != . 
replace sig`i' = . if start_crisisf3 == 1 |start_crisisf2 == 1 | start_crisisf1 == 1 ///
					  | start_crisis == 1 | start_crisisl1 == 1 | start_crisisl2 == 1 ///
					  | start_crisisl3 == 1 | start_crisisl4 == 1 | start_crisisl5 == 1 ///
					  | start_crisisl6 == 1 | start_crisisl7 == 1 
replace sig`i' = . if bankingcrisis == 1 
gen counter_yesyes`i' = 1 if sig`i' == 1 & PRECRISIS == 1
gen counter_yesno`i' = 1 if sig`i' == 1 & PRECRISIS == 0
gen counter_noyes`i' = 1 if sig`i' == 0 & PRECRISIS == 1
gen counter_nono`i' = 1 if sig`i' == 0 & PRECRISIS == 0
}

* one percentile for all countries (means that cutoff values vary over countries while percentile remains constant)
forvalues i=1(1)99{
egen global_A`i' = total(counter_yesyes`i')
egen global_B`i' = total(counter_yesno`i')
egen global_C`i' = total(counter_noyes`i')
egen global_D`i' = total(counter_nono`i')
gen global_A_AC`i' = global_A`i' / ( global_A`i' + global_C`i' )
gen global_A_AB`i' = global_A`i' / ( global_A`i' + global_B`i' )
gen global_C_AC`i' = global_C`i' / ( global_A`i' + global_C`i' )
gen global_B_BD`i' = global_B`i' / ( global_B`i' + global_D`i' )
gen global_AC_ABCD`i' = ( global_A`i' + global_C`i' ) / ( global_A`i' + global_B`i' + global_C`i' + global_D`i' )
gen global_adj_noise_signal`i' = global_B_BD`i' / global_A_AC`i'
gen global_use`i' = cons3 - ( cons1 * global_C_AC`i' + cons2 * global_B_BD`i' )
gen weight_global_use`i' = wcons3 - ( p1mu1 * global_C_AC`i' + p2mu2 * global_B_BD`i' )
gen rel_weight_global_use`i' = ( wcons3 - ( p1mu1 * global_C_AC`i' + p2mu2 * global_B_BD`i' ) ) / wcons3
}

* identify maximum relative usefulness across percentiles
egen maxweightglobaluse = rowmax(weight_global_use*)
egen maxrelweightglobaluse = rowmax(rel_weight_global_use*)
* define the optimal thresholds and corresponding values as the ones where usefulness is at its maximum
gen optweight_thres_global = . 
gen ow_adj_noise_signal_global = .
gen optweight_perc_pred_global = . 
gen optweight_cond_prob_global = . 
gen optweight_prob_diff_global = .
gen optweight_TP = .
gen optweight_FP = .
gen optweight_TN = .
gen optweight_FN = . 
gen optweight_T1 = .
gen optweight_T2 = .
forvalues i=1(1)99{
replace optweight_thres_global = `i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace ow_adj_noise_signal_global = global_adj_noise_signal`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace optweight_perc_pred_global = global_A_AC`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace optweight_cond_prob_global = global_A_AB`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace optweight_prob_diff_global = global_A_AB`i' - global_AC_ABCD`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace optweight_TP = global_A`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace optweight_FP = global_B`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace optweight_TN = global_D`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace optweight_FN = global_C`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace optweight_T1 = global_C_AC`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace optweight_T2 = global_B_BD`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
}

* drop variables
forvalues i=1(1)99{
drop sig`i' counter_yesyes`i' counter_yesno`i' counter_noyes`i' counter_nono`i' ///
			global_A`i' global_B`i' global_C`i' global_D`i' global_A_AC`i'      ///
			global_A_AB`i' global_C_AC`i' global_B_BD`i' global_AC_ABCD`i'      ///
			global_adj_noise_signal`i' global_use`i' weight_global_use`i'       ///
			rel_weight_global_use`i'
			}

order varname cons1 optweight_thres_global ///
			  optweight_TP optweight_FP optweight_TN optweight_FN ///
			  optweight_T1 optweight_T2 ///
			  maxweightglobaluse maxrelweightglobaluse ///
			  ow_adj_noise_signal_global optweight_perc_pred_global ///
			  optweight_cond_prob_global optweight_prob_diff_global ///
			  

outsheet         varname cons1 optweight_thres_global optweight_TP optweight_FP optweight_TN optweight_FN ///
				 optweight_T1 optweight_T2 maxweightglobaluse maxrelweightglobaluse ow_adj_noise_signal_global ///
				 optweight_perc_pred_global optweight_cond_prob_global optweight_prob_diff_global ///
				 using "help.csv" in 1, comma nonames replace

appendfile help.csv calibration.csv 

erase help.csv

drop PRECRISIS EV_VAR varname cons1 cons2 cons3 p1mu1 p2mu2 wcons3 optweight_thres_global ///
	 optweight_TP optweight_FP optweight_TN optweight_FN optweight_T1 optweight_T2 		  ///
	 maxweightglobaluse maxrelweightglobaluse optweight_thres_global ow_adj_noise_signal_global ///
	 optweight_perc_pred_global optweight_cond_prob_global optweight_prob_diff_global  
 
	}
	}

restore

********************************************************************************

preserve 

drop if country == "UK" | country == "Australia" | country == "Canada"
drop country_id 
egen country_id = group(country)
* frequency of pre-crisis states  
egen p_1 = mean(crisis4_12)
sum p_1 
gen p_2 =  1 - p_1

foreach var in p13 p14 p15 p18 p19 p20 pa1 pa2 pa3 pa4 pa5 pa6 pa7 pa8  {
	gen `var'_cut = .
	}

set more off
foreach var in  p13 p14 p15 p18 p19 p20 pa1 pa2 pa3 pa4 pa5 pa6 pa7 pa8  {	
	forvalues i = 1(1)13 {
		egen `var'_cut`i' = cut(`var') if country_id == `i', group(100)
		replace `var'_cut = `var'_cut`i' if country_id == `i'
		drop `var'_cut`i'
	}
}

foreach var of varlist p13_cut p14_cut p15_cut p18_cut p19_cut p20_cut pa1_cut pa2_cut pa3_cut pa4_cut pa5_cut pa6_cut pa7_cut pa8_cut {
		forvalues j=0.85(0.05)1 {

** VARIABLE TO BE EVALUATED
gen EV_VAR = `var'
local var_name : variable label `var'
gen varname = "`var'"
** parameters: cons1 = mu, cons2 = 1-mu, cons3 = min(mu,1-mu), 
gen cons1 = `j'
gen cons2 = 1 - cons1 
egen cons3 = rowmin(cons1 cons2)
** period that you want to detect
gen PRECRISIS = crisis4_12

* probweighted
gen p1mu1 = p_1 * `j'
gen p2mu2 = p_2 * (1-`j')
egen wcons3 =  rowmin(p1mu1 p2mu2)

******

set more off

* generate signals based on percentile thresholds (50th to 99th percentile)
* generate counter variables for A, B, C, D fields
forvalues i=1(1)99{
gen sig`i' = .
replace sig`i' = 0 if EV_VAR < `i' & EV_VAR != . 
replace sig`i' = 1 if EV_VAR >= `i' & EV_VAR != . 
replace sig`i' = . if start_crisisf3 == 1 |start_crisisf2 == 1 | start_crisisf1 == 1 ///
					  | start_crisis == 1 | start_crisisl1 == 1 | start_crisisl2 == 1 ///
					  | start_crisisl3 == 1 | start_crisisl4 == 1 | start_crisisl5 == 1 ///
					  | start_crisisl6 == 1 | start_crisisl7 == 1 
replace sig`i' = . if bankingcrisis == 1 
gen counter_yesyes`i' = 1 if sig`i' == 1 & PRECRISIS == 1
gen counter_yesno`i' = 1 if sig`i' == 1 & PRECRISIS == 0
gen counter_noyes`i' = 1 if sig`i' == 0 & PRECRISIS == 1
gen counter_nono`i' = 1 if sig`i' == 0 & PRECRISIS == 0
}

* one percentile for all countries (means that cutoff values vary over countries while percentile remains constant)
forvalues i=1(1)99{
egen global_A`i' = total(counter_yesyes`i')
egen global_B`i' = total(counter_yesno`i')
egen global_C`i' = total(counter_noyes`i')
egen global_D`i' = total(counter_nono`i')
gen global_A_AC`i' = global_A`i' / ( global_A`i' + global_C`i' )
gen global_A_AB`i' = global_A`i' / ( global_A`i' + global_B`i' )
gen global_C_AC`i' = global_C`i' / ( global_A`i' + global_C`i' )
gen global_B_BD`i' = global_B`i' / ( global_B`i' + global_D`i' )
gen global_AC_ABCD`i' = ( global_A`i' + global_C`i' ) / ( global_A`i' + global_B`i' + global_C`i' + global_D`i' )
gen global_adj_noise_signal`i' = global_B_BD`i' / global_A_AC`i'
gen global_use`i' = cons3 - ( cons1 * global_C_AC`i' + cons2 * global_B_BD`i' )
gen weight_global_use`i' = wcons3 - ( p1mu1 * global_C_AC`i' + p2mu2 * global_B_BD`i' )
gen rel_weight_global_use`i' = ( wcons3 - ( p1mu1 * global_C_AC`i' + p2mu2 * global_B_BD`i' ) ) / wcons3
}

* identify maximum relative usefulness across percentiles
egen maxweightglobaluse = rowmax(weight_global_use*)
egen maxrelweightglobaluse = rowmax(rel_weight_global_use*)
* define the optimal thresholds and corresponding values as the ones where usefulness is at its maximum
gen optweight_thres_global = . 
gen ow_adj_noise_signal_global = .
gen optweight_perc_pred_global = . 
gen optweight_cond_prob_global = . 
gen optweight_prob_diff_global = .
gen optweight_TP = .
gen optweight_FP = .
gen optweight_TN = .
gen optweight_FN = . 
gen optweight_T1 = .
gen optweight_T2 = .
forvalues i=1(1)99{
replace optweight_thres_global = `i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace ow_adj_noise_signal_global = global_adj_noise_signal`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace optweight_perc_pred_global = global_A_AC`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace optweight_cond_prob_global = global_A_AB`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace optweight_prob_diff_global = global_A_AB`i' - global_AC_ABCD`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace optweight_TP = global_A`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace optweight_FP = global_B`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace optweight_TN = global_D`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace optweight_FN = global_C`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace optweight_T1 = global_C_AC`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
replace optweight_T2 = global_B_BD`i' if weight_global_use`i' == maxweightglobaluse & weight_global_use`i'!= .
}

* drop variables
forvalues i=1(1)99{
drop sig`i' counter_yesyes`i' counter_yesno`i' counter_noyes`i' counter_nono`i' ///
			global_A`i' global_B`i' global_C`i' global_D`i' global_A_AC`i'      ///
			global_A_AB`i' global_C_AC`i' global_B_BD`i' global_AC_ABCD`i'      ///
			global_adj_noise_signal`i' global_use`i' weight_global_use`i'       ///
			rel_weight_global_use`i'
			}

order varname cons1 optweight_thres_global ///
			  optweight_TP optweight_FP optweight_TN optweight_FN ///
			  optweight_T1 optweight_T2 ///
			  maxweightglobaluse maxrelweightglobaluse ///
			  ow_adj_noise_signal_global optweight_perc_pred_global ///
			  optweight_cond_prob_global optweight_prob_diff_global ///
			  

outsheet         varname cons1 optweight_thres_global optweight_TP optweight_FP optweight_TN optweight_FN ///
				 optweight_T1 optweight_T2 maxweightglobaluse maxrelweightglobaluse ow_adj_noise_signal_global ///
				 optweight_perc_pred_global optweight_cond_prob_global optweight_prob_diff_global ///
				 using "help.csv" in 1, comma nonames replace

appendfile help.csv calibration.csv 

erase help.csv

drop PRECRISIS EV_VAR varname cons1 cons2 cons3 p1mu1 p2mu2 wcons3 optweight_thres_global ///
	 optweight_TP optweight_FP optweight_TN optweight_FN optweight_T1 optweight_T2 		  ///
	 maxweightglobaluse maxrelweightglobaluse optweight_thres_global ow_adj_noise_signal_global ///
	 optweight_perc_pred_global optweight_cond_prob_global optweight_prob_diff_global  
 
	}
	}

restore


























			   
											   
											   
											   

											   
											   
											   
											   

											   
											   
											   
											   
											   
											   
											   
											   
											   
											   
											   
											   
											   
											   
											   
											   
											   
											   
											   




